/*------------------------------------------------------------------------------*
 * File Name: ocMenuID.h														*
 * Creation: CPY June 29, 2005												    *
 * Purpose: IDs for Origin main menus that are needed in both VC and OC			*
 * Copyright (c) OriginLab Corp.2005											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	ML 7/7/2005 QA70-7869 MENUCONFIGURATION_FROM_XML_FILES_FOR_CONTEXT_MENUS	*
 *	TD 11-17-05 QA70-7835 ORIGIN_PATH_PROJECT_INSERTED							*
 *	DSC 2/23/06 8.50369 QA70-8462 ADD_ORIGIN_PATH_CUSTOM						*
 *	DSC 2/27/06 8.50369 QA70-8462 REMOVE_PROJECT_AND_CUSTOM_XF_IDS				*
 *	ML 5/27/2006 MRU_ANALYSIS_COMMANDS											*
 *	Max 1/27/07 ADD_XF_WKS_FORMAT_ID											*
 *	Max 3/20/07 ADD_XF_GRAPH_CM_PAGE_ID											*
 *	Max 4/17/07 ADD_XF_HELP_ID_FOR_ALL_WINDOWS									*
 *	TD 7-17-07 Qa80-10062 XFN_DRIVEN_CTXT_MENU_TO_COPY_SPARKLINE_IMMAGE			*
 *	TD 07-08-2009 QA80-13872 XFUNCTION_MENUS_FOR_PE_FOLDERS						*
 *	CPY 8/6/09 QA70-14093 SEND_MULTI_PAGES_TO_FAVORITES_SHORTCUTS				*
 *	TD ML 08-27-2009 QA80-13732 CONTEXT_SENSITIVE_CONTEXT_DRIVEN_XFUNCTIONS		*
 *	Kyle 12/30/2009 QA80-14903 ROI_TOOLS_MAIN_MENU_FOR_GRAPH					*
 *------------------------------------------------------------------------------*/

#ifndef _OMENU_ID_H
#define _OMENU_ID_H

// a replacement of the following
/*
	IDXF_USGCTXT_GRAPH_ANALYSIS		= 359,
	IDXF_USGCTXT_GRAPH_GRAPH		= 452,
	IDXF_USGCTXT_GRAPH_DATA			= 453,

	IDXF_USGCTXT_WKS_FILE			= 459,
	IDXF_USGCTXT_WKS_ANALYSIS		= 360,
	IDXF_USGCTXT_WKS_STATISTICS		= 361,

	IDXF_USGCTXT_MAT_EDIT			= 454,	
	IDXF_USGCTXT_MAT_MATRIX			= 455,
	IDXF_USGCTXT_MAT_IMAGE			= 456,
	IDXF_USGCTXT_MAT_FILE			= 457,
	IDXF_USGCTXT_MAT_ANALYSIS		= 458,
*/

/// ML 7/7/2005 QA70-7869 MENUCONFIGURATION_FROM_XML_FILES_FOR_CONTEXT_MENUS
//#define			ID_XF_BEGIN								0xaff0

// Note that ouserres.h contains ID_OC_CLASS_AWARE_MENU_END		0xAF00
// This is the beginning of the placeholders range (the range ends at ID_XF_MENU_END, see okext.cpp): 
#define			ID_XF_BEGIN								0xaf01
/// end MENUCONFIGURATION_FROM_XML_FILES_FOR_CONTEXT_MENUS

//////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////// Place-holders BEGIN ////////////////////////////////////
// These IDs are used to recognize the main menu dropdowns (i.e. they are place holders):
#define			ID_DYN_XF_GRAPH_FILE					0xaf01
#define			ID_DYN_XF_GRAPH_EDIT					0xaf02
#define			ID_DYN_XF_GRAPH_VIEW					0xaf03
#define			ID_DYN_XF_GRAPH_GRAPH					0xaf04
#define			ID_DYN_XF_GRAPH_DATA					0xaf05
#define			ID_DYN_XF_GRAPH_ANALYSIS				0xaf06
#define			ID_DYN_XF_GRAPH_GADGETS					0xaf07	///Kyle 12/30/2009 QA80-14903 ROI_TOOLS_MAIN_MENU_FOR_GRAPH

#define			ID_DYN_XF_GRAPH_CM_PLOTLINE				0xaf10
#define			ID_DYN_XF_GRAPH_CM_PLOTLINE3D			0xaf11
#define			ID_DYN_XF_GRAPH_CM_PAGE					0xaf12 /// Max 3/20/07 ADD_XF_GRAPH_CM_PAGE_ID
#define			ID_DYN_XF_GRAPH_CM_LR_ICON				0xaf13 /// TD ML 08-27-2009 QA80-13732 CONTEXT_SENSITIVE_CONTEXT_DRIVEN_XFUNCTIONS


#define			ID_DYN_XF_WKS_FILE						0xaf20
#define			ID_DYN_XF_WKS_EDIT						0xaf21
#define			ID_DYN_XF_WKS_VIEW						0xaf22
#define			ID_DYN_XF_WKS_COLUMN					0xaf23
#define			ID_DYN_XF_WKS_WORKSHEET					0xaf24
#define			ID_DYN_XF_WKS_ANALYSIS					0xaf25
#define			ID_DYN_XF_WKS_STATS						0xaf26
#define			ID_DYN_XF_WKS_TOOLS						0xaf27
#define			ID_DYN_XF_WKS_IMAGE						0xaf28
#define			ID_DYN_XF_WKS_FORMAT					0xaf29	/// Max 1/27/07 ADD_XF_WKS_FORMAT_ID

#define			ID_DYN_XF_WKS_CM_OUTSIDE				0xaf35
#define			ID_DYN_XF_WKS_CM_ROWNUM					0xaf36
#define			ID_DYN_XF_WKS_CM_COLHEAD				0xaf37
#define			ID_DYN_XF_WKS_CM_NX1					0xaf38
#define			ID_DYN_XF_WKS_CM_NXM					0xaf39
#define			ID_DYN_XF_WKS_CM_1XM					0xaf3a
#define			ID_DYN_XF_WKS_CM_ROWNUMS				0xaf3b
#define			ID_DYN_XF_WKS_CM_COLHEADS				0xaf3c
#define			ID_DYN_XF_WKS_CM_CELL					0xaf3e
#define			ID_DYN_XF_WKS_CM_LABELCELL				0xaf3f
#define			ID_DYN_XF_WKS_CM_SPARKLINE				0xaf40
#define			ID_DYN_XF_WKS_CM_LABELROWNUMS			0xaf41

#define			ID_DYN_XF_MAT_FILE						0xaf50	
#define			ID_DYN_XF_MAT_EDIT						0xaf51	
#define			ID_DYN_XF_MAT_MATRIX					0xaf52
#define			ID_DYN_XF_MAT_IMAGE						0xaf53
#define			ID_DYN_XF_MAT_ANALYSIS					0xaf54

#define			ID_DYN_XF_ANY_WIN_BEGIN					0xaf57	//--- CPY 7/11/09 QA80-13872 XFUNCTION_MENUS_FOR_PE_FOLDERS_NEED_ANY_WIN_SUPPORT
#define			ID_DYN_XF_TOOLS							0xaf57	//CPY 8/30/2007 QA70-10324 MOVE_GROUP_FOLDER_XF_TO_TOOLS_MENU
#define			ID_DYN_XF_HELP							0xaf59	/// Max 4/17/07 ADD_XF_HELP_ID_FOR_ALL_WINDOWS

/// TD 07-08-2009 QA80-13872 XFUNCTION_MENUS_FOR_PE_FOLDERS
#define			ID_DYN_XF_SEL_1_FOLDER					0xaf5A	//single folder selected CPY 7/11/09 changed from 0xaf60
#define			ID_DYN_XF_SEL_M_WINS					0xaf5B //---CPY 8/6/09 QA70-14093 SEND_MULTI_PAGES_TO_FAVORITES_SHORTCUTS	
#define			ID_DYN_XF_SEL_1_WIN						0xaf5C //---CPY 8/6/09 QA70-14093 SEND_MULTI_PAGES_TO_FAVORITES_SHORTCUTS	
/// end XFUNCTION_MENUS_FOR_PE_FOLDERS
#define			 ID_DYN_XF_ANY_WIN_END					0xaf65

//------ CPY, the following range are for theme capable XF menus, so internally will have a gap of 16 between them
#define			ID_XF_USER_BEGIN						0xb000
#define			ID_XF_USER_END							0xbff0 // total 255
#define			ID_XF_GROUP_BEGIN						0xc000
//----- CPY 12/12/06 RUN_OUT_OF_XF_ID_FOR_SYSTEM
//#define			ID_XF_GROUP_END							0xc2f0	// for group, less needed, total 47
//#define			ID_XF_SYSTEM_BEGIN						0xc300
//#define			ID_XF_SYSTEM_END						0xcef0	// system, this is what we ship, total 239
//------
/// TD 5-19-05 QA70-7739 XFUNCTION_TOOLBAR
//#define			ID_XF_END								0xc7f0
// CPY, the following range are for contiguours XF menus
#define			ID_XF_GROUP_END							0xc1f0	// for group, less needed, total 31
#define			ID_XF_SYSTEM_BEGIN						0xc200
#define			ID_XF_SYSTEM_END						0xd1f0	// system, this is what we ship, total 255

#define			ID_XF_TB_USER_BEGIN						0xd200 // total 319
//-----	end RUN_OUT_OF_XF_ID_FOR_SYSTEM
#define			ID_XF_TB_USER_END						0xd33f // user XF in toolbar and in menus without needing theme support
#define			ID_XF_TB_GROUP_BEGIN					0xd340
#define			ID_XF_TB_GROUP_END						0xd36f // total 11
#define			ID_XF_TB_SYSTEM_BEGIN					0xd370
//----- CPY 12/12/06 RUN_OUT_OF_XF_ID_FOR_SYSTEM
//#define			ID_XF_TB_SYSTEM_END						0xd54F // total 479
#define			ID_XF_TB_SYSTEM_END						0xd5F0	 // total 640
//------

///DSC 2/27/06 8.50369 QA70-8462 REMOVE_PROJECT_AND_CUSTOM_XF_IDS
// we dont need Project or Custom xf to appear in origin menus or toolbars
/*
/// TD 11-17-05 QA70-7835 ORIGIN_PATH_PROJECT_INSERTED
//#define			ID_XF_END								ID_XF_TB_SYSTEM_END
#define			ID_XF_TB_PROJECT_BEGIN					0xd550
#define			ID_XF_TB_PROJECT_END					0xd55F 

#define			ID_XF_PROJECT_BEGIN						0xd560
#define			ID_XF_PROJECT_END						0xd5F0	

///DSC 2/23/06 8.50369 QA70-8462 ADD_ORIGIN_PATH_CUSTOM
// #define			ID_XF_END								ID_XF_PROJECT_END
/// ADD_ORIGIN_PATH_CUSTOM

/// end ORIGIN_PATH_PROJECT_INSERTED

///DSC 2/23/06 8.50369 QA70-8462 ADD_ORIGIN_PATH_CUSTOM
#define			ID_XF_TB_CUSTOM_BEGIN					0xd5F1
#define			ID_XF_TB_CUSTOM_END						0xd5FF 

#define			ID_XF_CUSTOM_BEGIN						0xd600
#define			ID_XF_CUSTOM_END						0xd6FF

///end ADD_ORIGIN_PATH_CUSTOM


////////////////////////////////////////////////////////////////////////////////////////////////////////////
//-------- CPY 2/26/06 MFC menu res ID starts from 0xE000, so we must make sure we don't go beyound 0xdFFF
////////////////////////////////////////////////////////////////////////////////////////////////////////////
//#define			ID_XF_END								0xdFFF 
*/
///end ADD_ORIGIN_PATH_CUSTOM

/// ML 5/27/2006 MRU_ANALYSIS_COMMANDS
//#define			ID_XF_END								ID_XF_TB_SYSTEM_END

#define			ID_MRUAC_BEGIN							0xd900
#define			ID_MRUAC_END							0xda00

#define			ID_XF_END								ID_MRUAC_END
/// end MRU_ANALYSIS_COMMANDS
/// REMOVE_PROJECT_AND_CUSTOM_XF_IDS


/// NOTE: !!!!!!! //////////////////////////////////////////////////////////////////////////////////////////
//-------- CPY 2/26/06 MFC menu res ID starts from 0xE000, so we must make sure we don't go beyound 0xdFFF
////////////////////////////////////////////////////////////////////////////////////////////////////////////



////////////////////////////////////// Place-holders END /////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////

#endif //_OMENU_ID_H
